Ext.data.JsonP.sol_common_ix_ConnectionUtils({"tagname":"class","name":"sol.common.ix.ConnectionUtils","autodetected":{},"files":[{"filename":"lib_sol.common.ConnectionUtils.js","href":"lib_sol.common.ConnectionUtils.html#sol-common-ix-ConnectionUtils"}],"singleton":true,"eloix":true,"members":[{"name":"getConnection","tagname":"method","owner":"sol.common.ix.ConnectionUtils","id":"method-getConnection","meta":{}},{"name":"getCurrentUser","tagname":"method","owner":"sol.common.ix.ConnectionUtils","id":"method-getCurrentUser","meta":{}},{"name":"useTimeZone","tagname":"method","owner":"sol.common.ix.ConnectionUtils","id":"method-useTimeZone","meta":{}}],"alternateClassNames":[],"aliases":{},"id":"class-sol.common.ix.ConnectionUtils","classIcon":"icon-singleton","superclasses":[],"subclasses":[],"mixedInto":[],"mixins":[],"parentMixins":[],"requires":[],"uses":[],"html":"<div><pre class=\"hierarchy\"><h4>Files</h4><div class='dependency'><a href='source/lib_sol.common.ConnectionUtils.html#sol-common-ix-ConnectionUtils' target='_blank'>lib_sol.common.ConnectionUtils.js</a></div></pre><div class='doc-contents'><p>This class provides basic provider for ix (admin) connections.</p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-getConnection' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.ConnectionUtils'>sol.common.ix.ConnectionUtils</span><br/><a href='source/lib_sol.common.ConnectionUtils.html#sol-common-ix-ConnectionUtils-method-getConnection' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.ConnectionUtils-method-getConnection' class='name expandable'>getConnection</a>( <span class='pre'>asAdmin</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns ixConnectAdmin connection object as soon it is defined. ...</div><div class='long'><p>Returns <code>ixConnectAdmin</code> connection object as soon it is defined.\nOtherwise usually <code>ixConnect</code> object will be returned</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>asAdmin</span> : Boolean<div class='sub-desc'><p>If <code>true</code> and admin context is available it will be returned ixConnectAdmin</p>\n</div></li></ul></div></div></div><div id='method-getCurrentUser' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.ConnectionUtils'>sol.common.ix.ConnectionUtils</span><br/><a href='source/lib_sol.common.ConnectionUtils.html#sol-common-ix-ConnectionUtils-method-getCurrentUser' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.ConnectionUtils-method-getCurrentUser' class='name expandable'>getCurrentUser</a>( <span class='pre'></span> ) : Object<span class=\"signature\"></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>current logged in user</p>\n</div></li></ul></div></div></div><div id='method-useTimeZone' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.ConnectionUtils'>sol.common.ix.ConnectionUtils</span><br/><a href='source/lib_sol.common.ConnectionUtils.html#sol-common-ix-ConnectionUtils-method-useTimeZone' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.ConnectionUtils-method-useTimeZone' class='name expandable'>useTimeZone</a>( <span class='pre'>timeZone</span> ) : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>Change temporary timeZone of the current ixConnection. ...</div><div class='long'><p>Change temporary timeZone of the current ixConnection.</p>\n\n<p>It is important that you restore the timeZone of the connection when you don't use\nit anymore</p>\n\n<p>var timeZoneEvent = sol.common.IxConnectionUtils.useTemporaryTimeZone(timeZone);\n...\ntimeZoneEvent.restore()</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>timeZone</span> : String<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'>\n</div></li></ul></div></div></div></div></div></div></div>","meta":{"eloix":true,"singleton":true}});